/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.model;

import cofh.core.util.helpers.FluidHelper;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public final class FluidContainerItemModel
implements IUnbakedGeometry<FluidContainerItemModel> {
    private static final Transformation FLUID_TRANSFORM = new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.002f), Quaternion.f_80118_);
    private static final Transformation COVER_TRANSFORM = new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.004f), Quaternion.f_80118_);
    private static final IQuadTransformer MAX_LIGHTMAP_TRANSFORMER = QuadTransformers.applyingLightmap((int)0xF000F0);
    @Nonnull
    private final FluidStack fluidStack;

    public FluidContainerItemModel(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public FluidContainerItemModel withProperties(FluidStack newFluid) {
        return new FluidContainerItemModel(newFluid);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        Material particleLocation = context.hasMaterial("particle") ? context.getMaterial("particle") : null;
        Material fluidMaskLocation = context.hasMaterial("fluid_mask") ? context.getMaterial("fluid_mask") : null;
        Material baseLocation = context.hasMaterial("layer0") ? context.getMaterial("layer0") : null;
        Fluid fluid = this.fluidStack.getFluid();
        TextureAtlasSprite fluidSprite = fluid != Fluids.f_76191_ ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(this.fluidStack))) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite != null ? fluidSprite : spriteGetter.apply(baseLocation);
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(bakery, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = FluidContainerItemModel.getLayerRenderTypes();
        if (baseLocation != null) {
            TextureAtlasSprite baseSprite = spriteGetter.apply(baseLocation);
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)baseSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> baseSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.m_6189_().m_121096_(FLUID_TRANSFORM), modelState.m_7538_());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (TextureAtlasSprite)templateSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
            boolean unlit = fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = FluidContainerItemModel.getLayerRenderTypes();
            if (unlit) {
                MAX_LIGHTMAP_TRANSFORMER.processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.hasMaterial("particle")) {
            texs.add(owner.getMaterial("particle"));
        }
        if (owner.hasMaterial("fluid_mask")) {
            texs.add(owner.getMaterial("fluid_mask"));
        }
        if (owner.hasMaterial("layer0")) {
            texs.add(owner.getMaterial("layer0"));
        }
        return texs;
    }

    public static RenderTypeGroup getLayerRenderTypes() {
        return new RenderTypeGroup(RenderType.m_110463_(), ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get());
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<Integer, BakedModel> cache = new Int2ObjectOpenHashMap();
        private final ModelBakery bakery;
        private final IGeometryBakingContext owner;
        private final FluidContainerItemModel parent;

        private ContainedFluidOverrideHandler(ModelBakery bakery, IGeometryBakingContext owner, FluidContainerItemModel parent) {
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            FluidStack fluidStack = FluidHelper.getFluidContainedInItem(stack).orElse(FluidStack.EMPTY);
            int fluidHash = FluidHelper.fluidHashcode(fluidStack);
            if (!this.cache.containsKey(fluidHash)) {
                FluidContainerItemModel unbaked = this.parent.withProperties(fluidStack);
                BakedModel bakedModel = unbaked.bake(this.owner, this.bakery, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("cofh_core", "fluid_container_override"));
                this.cache.put(fluidHash, bakedModel);
                return bakedModel;
            }
            return this.cache.get(fluidHash);
        }
    }

    public static class Loader
    implements IGeometryLoader<FluidContainerItemModel> {
        public FluidContainerItemModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ResourceLocation fluidName;
            Fluid fluid;
            FluidStack stack = FluidStack.EMPTY;
            if (jsonObject.has("fluid") && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName = new ResourceLocation(jsonObject.get("fluid").getAsString()))) != null) {
                stack = new FluidStack(fluid, 1000);
            }
            return new FluidContainerItemModel(stack);
        }
    }
}

