/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui;

import cofh.core.client.gui.ContainerScreenCoFH;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.ElementTexture;
import cofh.core.client.gui.element.SimpleTooltip;
import cofh.core.inventory.container.ItemFilterContainer;
import cofh.core.network.packet.server.FilterableGuiTogglePacket;
import cofh.core.util.filter.IFilterable;
import cofh.core.util.filter.IFilterableItem;
import cofh.core.util.helpers.FilterHelper;
import cofh.core.util.helpers.GuiHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.SoundHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class ItemFilterScreen
extends ContainerScreenCoFH<ItemFilterContainer> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cofh_core:textures/gui/generic.png");
    public static final ResourceLocation SLOT_OVERLAY = new ResourceLocation("cofh_core:textures/gui/elements/locked_overlay_slot.png");
    public static final String TEX_DENY_LIST = "cofh_core:textures/gui/filters/filter_deny_list.png";
    public static final String TEX_ALLOW_LIST = "cofh_core:textures/gui/filters/filter_allow_list.png";
    public static final String TEX_IGNORE_NBT = "cofh_core:textures/gui/filters/filter_ignore_nbt.png";
    public static final String TEX_USE_NBT = "cofh_core:textures/gui/filters/filter_use_nbt.png";

    public ItemFilterScreen(ItemFilterContainer container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
        this.texture = TEXTURE;
        this.info = GuiHelper.generatePanelInfo("info.cofh_core.item_filter");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < ((ItemFilterContainer)this.f_97732_).getFilterSize(); ++i) {
            Slot slot = (Slot)((ItemFilterContainer)this.f_97732_).f_38839_.get(i);
            this.addElement(GuiHelper.createSlot(this, slot.f_40220_, slot.f_40221_));
        }
        this.addButtons();
        switch (((ItemFilterContainer)this.f_97732_).type) {
            case ITEM: {
                if (!((ItemFilterContainer)this.f_97732_).getFilterableItem().hasGui(((ItemFilterContainer)this.f_97732_).getFilterStack())) break;
                this.addElement(new ElementTexture(this, 4, -21).setUV(24, 0).setSize(24, 21).setTexture("cofh_core:textures/gui/elements/tab_top.png", 48, 32).setVisible(() -> FilterHelper.hasFilter(((ItemFilterContainer)this.f_97732_).getFilterStack())));
                this.addElement(new ElementTexture(this, 8, -17){

                    @Override
                    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                        FilterableGuiTogglePacket.openGui(((ItemFilterContainer)ItemFilterScreen.this.f_97732_).getFilterStack());
                        return true;
                    }
                }.setSize(16, 16).setTexture("cofh_core:textures/gui/elements/nav_back.png", 16, 16).setTooltipFactory((element, mouseX, mouseY) -> {
                    List<Object> list;
                    IFilterableItem patt3176$temp = ((ItemFilterContainer)this.f_97732_).getFilterableItem();
                    if (patt3176$temp instanceof MenuProvider) {
                        MenuProvider menuProvider = (MenuProvider)patt3176$temp;
                        list = Collections.singletonList(menuProvider.m_5446_());
                    } else {
                        list = Collections.emptyList();
                    }
                    return list;
                }).setVisible(() -> FilterHelper.hasFilter(((ItemFilterContainer)this.f_97732_).getFilterStack())));
                break;
            }
            case TILE: 
            case ENTITY: {
                if (!((ItemFilterContainer)this.f_97732_).getFilterable().hasGui()) break;
                this.addElement(new ElementTexture(this, 4, -21).setUV(24, 0).setSize(24, 21).setTexture("cofh_core:textures/gui/elements/tab_top.png", 48, 32).setVisible(() -> FilterHelper.hasFilter(((ItemFilterContainer)this.f_97732_).getFilterable())));
                this.addElement(new ElementTexture(this, 8, -17){

                    @Override
                    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                        FilterableGuiTogglePacket.openGui(((ItemFilterContainer)ItemFilterScreen.this.f_97732_).getFilterable());
                        return true;
                    }
                }.setSize(16, 16).setTexture("cofh_core:textures/gui/elements/nav_back.png", 16, 16).setTooltipFactory((element, mouseX, mouseY) -> {
                    List<Object> list;
                    IFilterable patt4427$temp = ((ItemFilterContainer)this.f_97732_).getFilterable();
                    if (patt4427$temp instanceof MenuProvider) {
                        MenuProvider menuProvider = (MenuProvider)patt4427$temp;
                        list = Collections.singletonList(menuProvider.m_5446_());
                    } else {
                        list = Collections.emptyList();
                    }
                    return list;
                }).setVisible(() -> FilterHelper.hasFilter(((ItemFilterContainer)this.f_97732_).getFilterable())));
            }
        }
    }

    @Override
    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        if (((ItemFilterContainer)this.f_97732_).lockedSlot != null) {
            GlStateManager.m_84525_();
            RenderHelper.setPosTexShader();
            RenderHelper.setShaderTexture0(SLOT_OVERLAY);
            this.drawTexturedModalRect(poseStack, ((ItemFilterContainer)this.f_97732_).lockedSlot.f_40220_, ((ItemFilterContainer)this.f_97732_).lockedSlot.f_40221_, 0, 0, 16, 16, 16.0f, 16.0f);
            GlStateManager.m_84519_();
        }
    }

    protected void addButtons() {
        this.addElement(new ElementButton(this, 132, 22){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((ItemFilterContainer)ItemFilterScreen.this.f_97732_).setAllowList(true);
                SoundHelper.playClickSound(0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_DENY_LIST, 40, 20).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.filter.allowlist.0"))).setVisible(() -> !((ItemFilterContainer)this.f_97732_).getAllowList()));
        this.addElement(new ElementButton(this, 132, 22){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((ItemFilterContainer)ItemFilterScreen.this.f_97732_).setAllowList(false);
                SoundHelper.playClickSound(0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_ALLOW_LIST, 40, 20).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.filter.allowlist.1"))).setVisible(() -> ((ItemFilterContainer)this.f_97732_).getAllowList()));
        this.addElement(new ElementButton(this, 132, 44){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((ItemFilterContainer)ItemFilterScreen.this.f_97732_).setCheckNBT(true);
                SoundHelper.playClickSound(0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_IGNORE_NBT, 40, 20).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.filter.checkNBT.0"))).setVisible(() -> !((ItemFilterContainer)this.f_97732_).getCheckNBT()));
        this.addElement(new ElementButton(this, 132, 44){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((ItemFilterContainer)ItemFilterScreen.this.f_97732_).setCheckNBT(false);
                SoundHelper.playClickSound(0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_USE_NBT, 40, 20).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.filter.checkNBT.1"))).setVisible(() -> ((ItemFilterContainer)this.f_97732_).getCheckNBT()));
    }
}

