/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.IBoxable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.block.RubberLogBlock;
import ic2.core.ref.Ic2Blocks;
import ic2.core.ref.Ic2Items;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ItemTreetap
extends Item
implements IBoxable {
    public ItemTreetap(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        BlockPos blockPos;
        Level level = useOnContext.m_43725_();
        BlockState blockState = level.m_8055_(blockPos = useOnContext.m_8083_());
        Block block = blockState.m_60734_();
        if (block == Ic2Blocks.RUBBER_LOG) {
            Player player = useOnContext.m_43723_();
            if (ItemTreetap.attemptExtract(player, level, blockPos, useOnContext.m_43719_(), blockState, null)) {
                if (!level.f_46443_) {
                    StackUtil.damage(player, useOnContext.m_43724_(), StackUtil.anyStack, 1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static boolean attemptExtract(Player player, Level level, BlockPos blockPos, Direction direction, BlockState blockState, List<ItemStack> list) {
        assert (blockState.m_60734_() == Ic2Blocks.RUBBER_LOG);
        RubberLogBlock.RubberWoodState rubberWoodState = (RubberLogBlock.RubberWoodState)((Object)blockState.m_61143_(RubberLogBlock.stateProperty));
        if (rubberWoodState.isPlain() || rubberWoodState.facing != direction) {
            return false;
        }
        if (rubberWoodState.wet) {
            if (!level.f_46443_) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_(RubberLogBlock.stateProperty, (Comparable)((Object)rubberWoodState.getDry())));
                if (list != null) {
                    list.add(StackUtil.copyWithSize(new ItemStack((ItemLike)Ic2Items.RESIN), level.f_46441_.m_188503_(3) + 1));
                } else {
                    ItemTreetap.ejectResin(level, blockPos, direction, level.f_46441_.m_188503_(3) + 1);
                }
                if (player != null) {
                    IC2.achievements.issueAchievement(player, "acquireResin");
                }
            }
            if (level.f_46443_ && player != null) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/Treetap.ogg", true, IC2.audioManager.getDefaultVolume());
            }
            return true;
        }
        if (!level.f_46443_ && level.f_46441_.m_188503_(5) == 0) {
            level.m_46597_(blockPos, (BlockState)blockState.m_61124_(RubberLogBlock.stateProperty, (Comparable)((Object)RubberLogBlock.RubberWoodState.plain)));
        }
        if (level.f_46441_.m_188503_(5) == 0) {
            if (!level.f_46443_) {
                ItemTreetap.ejectResin(level, blockPos, direction, 1);
                if (list != null) {
                    list.add(new ItemStack((ItemLike)Ic2Items.RESIN));
                } else {
                    ItemTreetap.ejectResin(level, blockPos, direction, 1);
                }
            }
            if (level.f_46443_ && player != null) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/Treetap.ogg", true, IC2.audioManager.getDefaultVolume());
            }
            return true;
        }
        return false;
    }

    private static void ejectResin(Level level, BlockPos blockPos, Direction direction, int n) {
        double d = (double)blockPos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.3;
        double d2 = (double)blockPos.m_123342_() + 0.5 + (double)direction.m_122430_() * 0.3;
        double d3 = (double)blockPos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.3;
        for (int i = 0; i < n; ++i) {
            ItemEntity itemEntity = new ItemEntity(level, d, d2, d3, new ItemStack((ItemLike)Ic2Items.RESIN));
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemStack) {
        return true;
    }
}

