/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.item.ElectricItemManager;
import ic2.core.item.ElectricItemTooltipHandler;
import ic2.core.ref.Ic2BlockTags;
import ic2.core.util.StackUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class ItemElectricTool
extends DiggerItem
implements IElectricItem {
    public double operationEnergyCost;
    private final Collection<TagKey<Block>> effectiveBlocks;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    protected AudioSource audioSource;
    protected boolean wasEquipped;

    protected ItemElectricTool(Item.Properties properties, int n) {
        this(properties, n, (Tier)Tiers.IRON, Collections.emptyList());
    }

    protected ItemElectricTool(Item.Properties properties, int n, Tier tier, Collection<TagKey<Block>> collection) {
        this(properties, 2.0f, -3.0f, n, tier, collection);
    }

    private ItemElectricTool(Item.Properties properties, float f, float f2, int n, Tier tier, Collection<TagKey<Block>> collection) {
        super(f, f2, tier, collection.isEmpty() ? Ic2BlockTags.EMPTY : collection.iterator().next(), properties);
        this.operationEnergyCost = n;
        this.effectiveBlocks = collection;
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        ElectricItem.manager.use(useOnContext.m_43722_(), 0.0, (LivingEntity)useOnContext.m_43723_());
        return super.m_6225_(useOnContext);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ElectricItem.manager.use(StackUtil.get(player, interactionHand), 0.0, (LivingEntity)player);
        return super.m_7203_(level, player, interactionHand);
    }

    public float m_8102_(ItemStack itemStack, BlockState blockState) {
        if (!this.isEffective(blockState) || !ElectricItem.manager.canUse(itemStack, this.operationEnergyCost)) {
            return 1.0f;
        }
        return this.f_40980_;
    }

    public boolean m_8096_(BlockState blockState) {
        int n = this.m_43314_().m_6604_();
        if (n < 3 && blockState.m_204336_(BlockTags.f_144284_) || n < 2 && blockState.m_204336_(BlockTags.f_144285_) || n < 1 && blockState.m_204336_(BlockTags.f_144286_)) {
            return false;
        }
        return this.isEffective(blockState);
    }

    private boolean isEffective(BlockState blockState) {
        for (TagKey<Block> tagKey : this.effectiveBlocks) {
            if (!blockState.m_204336_(tagKey)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity livingEntity, LivingEntity livingEntity2) {
        return true;
    }

    public int m_6473_() {
        return 0;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if (blockState.m_60800_((BlockGetter)level, blockPos) != 0.0f) {
            if (livingEntity != null) {
                ElectricItem.manager.use(itemStack, this.operationEnergyCost, livingEntity);
            } else {
                ElectricItem.manager.discharge(itemStack, this.operationEnergyCost, this.tier, true, false, false);
            }
        }
        return true;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return false;
    }

    public void m_6787_(CreativeModeTab creativeModeTab, NonNullList<ItemStack> nonNullList) {
        if (!this.m_220152_(creativeModeTab)) {
            return;
        }
        ElectricItemManager.addChargeVariants((Item)this, nonNullList);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        ElectricItemTooltipHandler.addTooltip(itemStack, list);
    }

    protected ItemStack getItemStack(double d) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        ElectricItem.manager.charge(itemStack, d, Integer.MAX_VALUE, true, false);
        return itemStack;
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl && entity instanceof LivingEntity;
        if (IC2.sideProxy.isRendering()) {
            if (bl2 && !this.wasEquipped) {
                String string;
                if (this.audioSource == null && (string = this.getIdleSound((LivingEntity)entity, itemStack)) != null) {
                    this.audioSource = IC2.audioManager.createSource(entity, PositionSpec.Hand, string, true, false, IC2.audioManager.getDefaultVolume());
                }
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
                if ((string = this.getStartSound((LivingEntity)entity, itemStack)) != null) {
                    IC2.audioManager.playOnce(entity, PositionSpec.Hand, string, true, IC2.audioManager.getDefaultVolume());
                }
            } else if (!bl2 && this.audioSource != null) {
                LivingEntity livingEntity;
                ItemStack itemStack2;
                if (entity instanceof LivingEntity && ((itemStack2 = (livingEntity = (LivingEntity)entity).m_6844_(EquipmentSlot.MAINHAND)) == null || itemStack2.m_41720_() != this || itemStack2 == itemStack)) {
                    this.removeAudioSource();
                    String string = this.getStopSound(livingEntity, itemStack);
                    if (string != null) {
                        IC2.audioManager.playOnce(entity, PositionSpec.Hand, string, true, IC2.audioManager.getDefaultVolume());
                    }
                }
            } else if (this.audioSource != null) {
                this.audioSource.updatePosition();
            }
            this.wasEquipped = bl2;
        }
    }

    protected void removeAudioSource() {
        if (this.audioSource != null) {
            this.audioSource.stop();
            this.audioSource.remove();
            this.audioSource = null;
        }
    }

    public boolean onDroppedByPlayer(ItemStack itemStack, Player player) {
        this.removeAudioSource();
        return true;
    }

    protected String getIdleSound(LivingEntity livingEntity, ItemStack itemStack) {
        return null;
    }

    protected String getStopSound(LivingEntity livingEntity, ItemStack itemStack) {
        return null;
    }

    protected String getStartSound(LivingEntity livingEntity, ItemStack itemStack) {
        return null;
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142158_(ItemStack itemStack) {
        return (int)Math.round(ElectricItem.manager.getChargeLevel(itemStack) * 13.0);
    }

    public int m_142159_(ItemStack itemStack) {
        return Mth.m_14169_((float)((float)(ElectricItem.manager.getChargeLevel(itemStack) / 3.0)), (float)1.0f, (float)1.0f);
    }
}

