/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.armor.ItemArmorNanoSuit;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.slot.ArmorSlot;
import ic2.core.util.StackUtil;
import java.util.Collections;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractItemNanoSaber
extends ItemElectricTool {
    public static int ticker = 0;
    private int soundTicker = 0;

    public AbstractItemNanoSaber(Item.Properties properties) {
        super(properties, 10, (Tier)Tiers.DIAMOND, Collections.emptyList());
        this.maxCharge = 160000;
        this.transferLimit = 500;
        this.tier = 3;
    }

    public boolean m_41463_(ItemStack itemStack) {
        return super.m_41463_(itemStack);
    }

    @Override
    public float m_8102_(ItemStack itemStack, BlockState blockState) {
        if (AbstractItemNanoSaber.isActive(itemStack)) {
            ++this.soundTicker;
            if (IC2.sideProxy.isRendering() && this.soundTicker % 4 == 0) {
                IC2.sideProxy.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
            }
            return blockState.m_60734_() == Blocks.f_50033_ ? 50.0f : 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean m_7579_(ItemStack itemStack, LivingEntity livingEntity, LivingEntity livingEntity2) {
        if (!AbstractItemNanoSaber.isActive(itemStack)) {
            return true;
        }
        if (IC2.sideProxy.isSimulating()) {
            AbstractItemNanoSaber.drainSaber(itemStack, 400.0, livingEntity2);
            if (!(livingEntity2 instanceof ServerPlayer) || !(livingEntity instanceof Player) || ((ServerPlayer)livingEntity2).m_7099_((Player)livingEntity)) {
                for (EquipmentSlot equipmentSlot : ArmorSlot.getAll()) {
                    if (!ElectricItem.manager.canUse(itemStack, 2000.0)) break;
                    ItemStack itemStack2 = livingEntity.m_6844_(equipmentSlot);
                    if (itemStack2 == null) continue;
                    double d = 0.0;
                    if (itemStack2.m_41720_() instanceof ItemArmorNanoSuit) {
                        d = 48000.0;
                    } else if (itemStack2.m_41720_() instanceof ItemArmorQuantumSuit) {
                        d = 300000.0;
                    }
                    if (!(d > 0.0)) continue;
                    ElectricItem.manager.discharge(itemStack2, d, this.tier, true, false, false);
                    if (!ElectricItem.manager.canUse(itemStack2, 1.0)) {
                        livingEntity.m_8061_(equipmentSlot, null);
                    }
                    AbstractItemNanoSaber.drainSaber(itemStack, 2000.0, livingEntity2);
                }
            }
        }
        if (IC2.sideProxy.isRendering()) {
            IC2.sideProxy.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
        }
        return true;
    }

    public String getRandomSwingSound() {
        return switch (IC2.random.m_188503_(3)) {
            default -> "Tools/Nanosabre/NanosabreSwing1.ogg";
            case 1 -> "Tools/Nanosabre/NanosabreSwing2.ogg";
            case 2 -> "Tools/Nanosabre/NanosabreSwing3.ogg";
        };
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        if (player.m_7500_()) {
            return false;
        }
        return super.m_6777_(blockState, level, blockPos, player);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        return super.m_6225_(useOnContext);
    }

    public static void drainSaber(ItemStack itemStack, double d, LivingEntity livingEntity) {
        if (!ElectricItem.manager.use(itemStack, d, livingEntity)) {
            CompoundTag compoundTag = StackUtil.getOrCreateNbtData(itemStack);
            AbstractItemNanoSaber.setActive(compoundTag, false);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = StackUtil.get(player, interactionHand);
        if (level.f_46443_) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
        }
        CompoundTag compoundTag = StackUtil.getOrCreateNbtData(itemStack);
        if (AbstractItemNanoSaber.isActive(compoundTag)) {
            AbstractItemNanoSaber.setActive(compoundTag, false);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        if (ElectricItem.manager.canUse(itemStack, 16.0)) {
            AbstractItemNanoSaber.setActive(compoundTag, true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        return super.m_7203_(level, player, interactionHand);
    }

    @Override
    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int n, boolean bl) {
        super.m_6883_(itemStack, level, entity, n, bl && AbstractItemNanoSaber.isActive(itemStack));
        if (!AbstractItemNanoSaber.isActive(itemStack)) {
            return;
        }
        if (ticker % 16 == 0 && entity instanceof ServerPlayer) {
            if (n < 9) {
                AbstractItemNanoSaber.drainSaber(itemStack, 64.0, (LivingEntity)((Player)entity));
            } else if (ticker % 64 == 0) {
                AbstractItemNanoSaber.drainSaber(itemStack, 16.0, (LivingEntity)((Player)entity));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public Rarity m_41460_(ItemStack itemStack) {
        return Rarity.UNCOMMON;
    }

    public static boolean isActive(ItemStack itemStack) {
        CompoundTag compoundTag = StackUtil.getOrCreateNbtData(itemStack);
        return AbstractItemNanoSaber.isActive(compoundTag);
    }

    public static boolean isActive(CompoundTag compoundTag) {
        return compoundTag.m_128471_("active");
    }

    private static void setActive(CompoundTag compoundTag, boolean bl) {
        compoundTag.m_128379_("active", bl);
    }

    @Override
    protected String getIdleSound(LivingEntity livingEntity, ItemStack itemStack) {
        return "Tools/Nanosabre/NanosabreIdle.ogg";
    }

    @Override
    protected String getStartSound(LivingEntity livingEntity, ItemStack itemStack) {
        return "Tools/Nanosabre/NanosabrePowerup.ogg";
    }
}

