/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop.cropcard;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.crop.IC2CropCard;
import ic2.core.ref.Ic2Items;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CropVenomilia
extends IC2CropCard {
    @Override
    public String getId() {
        return "venomilia";
    }

    @Override
    public String getDiscoveredBy() {
        return "raGan";
    }

    @Override
    public CropProperties getProperties() {
        return new CropProperties(3, 3, 1, 3, 3, 3);
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Purple", "Flower", "Tulip", "Poison"};
    }

    @Override
    public int getMaxSize() {
        return 6;
    }

    @Override
    public boolean canGrow(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() <= 4 && iCropTile.getLightLevel() >= 12 || iCropTile.getCurrentSize() == 5;
    }

    @Override
    public boolean canBeHarvested(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() >= 4;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile iCropTile) {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile iCropTile) {
        if (iCropTile.getCurrentSize() == 5) {
            return new ItemStack((ItemLike)Ic2Items.GRIN_POWDER);
        }
        if (iCropTile.getCurrentSize() >= 4) {
            return new ItemStack((ItemLike)Items.f_42493_);
        }
        return null;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile iCropTile) {
        return 3;
    }

    @Override
    public int getGrowthDuration(ICropTile iCropTile) {
        if (iCropTile.getCurrentSize() >= 3) {
            return 600;
        }
        return 400;
    }

    @Override
    public boolean onRightClick(ICropTile iCropTile, Player player) {
        if (!player.m_6144_()) {
            this.onEntityCollision(iCropTile, (Entity)player);
        }
        return iCropTile.performManualHarvest();
    }

    @Override
    public boolean onLeftClick(ICropTile iCropTile, Player player) {
        if (!player.m_6144_()) {
            this.onEntityCollision(iCropTile, (Entity)player);
        }
        return iCropTile.pick();
    }

    @Override
    public boolean onEntityCollision(ICropTile iCropTile, Entity entity) {
        if (iCropTile.getCurrentSize() == 5 && entity instanceof LivingEntity) {
            if (entity instanceof Player && ((Player)entity).m_6144_() && IC2.random.m_188503_(50) != 0) {
                return super.onEntityCollision(iCropTile, entity);
            }
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, (IC2.random.m_188503_(10) + 5) * 20, 0));
            iCropTile.setCurrentSize(4);
            iCropTile.updateState();
        }
        return super.onEntityCollision(iCropTile, entity);
    }

    @Override
    public boolean isWeed(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() == 5 && iCropTile.getStatGrowth() >= 8;
    }
}

