/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop.cropcard;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.crop.IC2CropCard;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CropRedWheat
extends IC2CropCard {
    @Override
    public String getId() {
        return "redwheat";
    }

    @Override
    public String getDiscoveredBy() {
        return "raa1337";
    }

    @Override
    public CropProperties getProperties() {
        return new CropProperties(6, 3, 0, 0, 2, 0);
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Red", "Redstone", "Wheat"};
    }

    @Override
    public int getMaxSize() {
        return 7;
    }

    @Override
    public boolean canGrow(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() < 7 && iCropTile.getLightLevel() <= 10 && iCropTile.getLightLevel() >= 5;
    }

    @Override
    public boolean canBeHarvested(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() == 7;
    }

    @Override
    public double dropGainChance() {
        return 0.5;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile iCropTile) {
        return 7;
    }

    @Override
    public ItemStack getGain(ICropTile iCropTile) {
        BlockPos blockPos = iCropTile.getPosition();
        if (iCropTile.getWorldObj().m_46755_(blockPos) > 0 || iCropTile.getWorldObj().f_46441_.m_188499_()) {
            return new ItemStack((ItemLike)Items.f_42451_, 1);
        }
        return new ItemStack((ItemLike)Items.f_42405_, 1);
    }

    @Override
    public boolean isRedstoneSignalEmitter(ICropTile iCropTile) {
        return true;
    }

    @Override
    public int getEmittedRedstoneSignal(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() == 7 ? 15 : 0;
    }

    @Override
    public int getEmittedLight(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() == 7 ? 7 : 0;
    }

    @Override
    public int getGrowthDuration(ICropTile iCropTile) {
        return 600;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile iCropTile) {
        return 2;
    }
}

