/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop.cropcard;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.crop.IC2CropCard;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CropColorFlower
extends IC2CropCard {
    public String name;
    public String[] attributes;
    public DyeColor color;

    public CropColorFlower(String string, String[] stringArray, DyeColor dyeColor) {
        this.name = string;
        this.attributes = stringArray;
        this.color = dyeColor;
    }

    @Override
    public String getDiscoveredBy() {
        if (this.name.equals("dandelion") || this.name.equals("rose")) {
            return "Notch";
        }
        return "Alblaka";
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public CropProperties getProperties() {
        return new CropProperties(2, 1, 1, 0, 5, 1);
    }

    @Override
    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public boolean canGrow(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() <= 3 && iCropTile.getLightLevel() >= 12;
    }

    @Override
    public boolean canBeHarvested(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() == 4;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile iCropTile) {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile iCropTile) {
        return new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)this.color));
    }

    @Override
    public int getSizeAfterHarvest(ICropTile iCropTile) {
        return 3;
    }

    @Override
    public int getGrowthDuration(ICropTile iCropTile) {
        if (iCropTile.getCurrentSize() == 3) {
            return 600;
        }
        return 400;
    }
}

