/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop.cropcard;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.crop.IC2CropCard;
import ic2.core.ref.Ic2Items;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CropCoffee
extends IC2CropCard {
    @Override
    public String getId() {
        return "coffee";
    }

    @Override
    public String getDiscoveredBy() {
        return "Snoochy";
    }

    @Override
    public CropProperties getProperties() {
        return new CropProperties(7, 1, 4, 1, 2, 0);
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Leaves", "Ingredient", "Beans"};
    }

    @Override
    public int getMaxSize() {
        return 5;
    }

    @Override
    public boolean canGrow(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() < 5 && iCropTile.getLightLevel() >= 9;
    }

    @Override
    public int getWeightInfluences(ICropTile iCropTile, int n, int n2, int n3) {
        return (int)(0.4 * (double)n + 1.4 * (double)n2 + 1.2 * (double)n3);
    }

    @Override
    public int getGrowthDuration(ICropTile iCropTile) {
        if (iCropTile.getCurrentSize() == 3) {
            return (int)((double)super.getGrowthDuration(iCropTile) * 0.5);
        }
        if (iCropTile.getCurrentSize() == 4) {
            return (int)((double)super.getGrowthDuration(iCropTile) * 1.5);
        }
        return super.getGrowthDuration(iCropTile);
    }

    @Override
    public boolean canBeHarvested(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() >= 4;
    }

    @Override
    public ItemStack getGain(ICropTile iCropTile) {
        if (iCropTile.getCurrentSize() == 4) {
            return null;
        }
        return new ItemStack((ItemLike)Ic2Items.COFFEE_BEANS);
    }

    @Override
    public int getSizeAfterHarvest(ICropTile iCropTile) {
        return 3;
    }
}

