/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop.cropcard;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.crop.IC2CropCard;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CropCocoa
extends IC2CropCard {
    @Override
    public String getId() {
        return "cocoa";
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    public CropProperties getProperties() {
        return new CropProperties(3, 1, 3, 0, 4, 0);
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Brown", "Food", "Stem"};
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public boolean canGrow(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() <= 3 && iCropTile.getStorageNutrients() >= 3;
    }

    @Override
    public int getWeightInfluences(ICropTile iCropTile, int n, int n2, int n3) {
        return (int)((double)n * 0.8 + (double)n2 * 1.3 + (double)n3 * 0.9);
    }

    @Override
    public int getOptimalHarvestSize(ICropTile iCropTile) {
        return 4;
    }

    @Override
    public boolean canBeHarvested(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() == 4;
    }

    @Override
    public ItemStack getGain(ICropTile iCropTile) {
        return new ItemStack((ItemLike)Items.f_42533_);
    }

    @Override
    public int getGrowthDuration(ICropTile iCropTile) {
        if (iCropTile.getCurrentSize() == 3) {
            return 900;
        }
        return 400;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile iCropTile) {
        return 3;
    }
}

