/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop.cropcard;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.crop.IC2CropCard;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CropBaseSapling
extends IC2CropCard {
    protected final String cropName;
    protected final String saplingName;
    protected final ItemStack cropDrop;
    protected final ItemStack cropSapling;

    public CropBaseSapling(String string, String string2, ItemStack itemStack, ItemStack itemStack2) {
        this.cropName = string;
        this.saplingName = "ic2.crop." + string2;
        this.cropDrop = itemStack;
        this.cropSapling = itemStack2;
    }

    @Override
    public String getId() {
        return this.cropName;
    }

    @Override
    public String getSeedType() {
        return this.saplingName;
    }

    @Override
    public String getDiscoveredBy() {
        return "Speiger";
    }

    @Override
    public CropProperties getProperties() {
        return new CropProperties(3, 1, 0, 4, 4, 0);
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Leaves", "Sapling", "Green"};
    }

    @Override
    public int getMaxSize() {
        return 5;
    }

    @Override
    public boolean canGrow(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() < this.getMaxSize() && iCropTile.getLightLevel() >= 9;
    }

    @Override
    public boolean canBeHarvested(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() == 5;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile iCropTile) {
        return 5;
    }

    @Override
    public ItemStack[] getGains(ICropTile iCropTile) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        arrayList.add(this.cropDrop.m_41777_());
        if (IC2.random.m_188503_(100) >= 75) {
            arrayList.add(this.cropSapling.m_41777_());
        }
        if (this.getId().equalsIgnoreCase("oak_sapling") && IC2.random.m_188503_(100) >= 75) {
            arrayList.add(new ItemStack((ItemLike)Items.f_42410_));
        }
        return arrayList.toArray(new ItemStack[arrayList.size()]);
    }

    @Override
    public int getGrowthDuration(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() >= 4 ? 150 : 600;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile iCropTile) {
        return 4;
    }
}

