/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop.cropcard;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.crop.IC2CropCard;
import java.util.Collection;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class CropBaseMetalCommon
extends IC2CropCard {
    protected final String cropName;
    protected final String[] cropAttributes;
    protected final Collection<TagKey<Block>> cropRootsRequirement;
    protected final ItemStack cropDrop;

    public CropBaseMetalCommon(String string, String[] stringArray, Collection<TagKey<Block>> collection, ItemStack itemStack) {
        this.cropName = string;
        this.cropAttributes = stringArray;
        this.cropRootsRequirement = collection;
        this.cropDrop = itemStack;
    }

    @Override
    public String getId() {
        return this.cropName;
    }

    @Override
    public CropProperties getProperties() {
        return new CropProperties(6, 2, 0, 0, 1, 0);
    }

    @Override
    public String[] getAttributes() {
        return this.cropAttributes;
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public boolean canGrow(ICropTile iCropTile) {
        int n = this.getMaxSize() - 1;
        if (iCropTile.getCurrentSize() < n) {
            return true;
        }
        if (iCropTile.getCurrentSize() == n) {
            if (this.cropRootsRequirement == null || this.cropRootsRequirement.isEmpty()) {
                return true;
            }
            for (TagKey<Block> tagKey : this.cropRootsRequirement) {
                if (!iCropTile.isBlockBelow(tagKey)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getRootsLength(ICropTile iCropTile) {
        return 5;
    }

    @Override
    public boolean canBeHarvested(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() == 4;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile iCropTile) {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile iCropTile) {
        return this.cropDrop.m_41777_();
    }

    @Override
    public double dropGainChance() {
        return super.dropGainChance() / 2.0;
    }

    @Override
    public int getGrowthDuration(ICropTile iCropTile) {
        if (iCropTile.getCurrentSize() == 3) {
            return 2000;
        }
        return 800;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile iCropTile) {
        return 2;
    }
}

