/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop;

import ic2.api.crops.ICropTile;
import ic2.core.crop.IC2CropCard;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CropBlock;

public abstract class CropVanilla
extends IC2CropCard {
    protected final int maxAge;

    protected CropVanilla(CropBlock cropBlock) {
        this(cropBlock.m_7419_());
    }

    protected CropVanilla(int n) {
        this.maxAge = n;
    }

    protected List<ResourceLocation> getDefaultTexturesLocation() {
        return super.getTexturesLocation();
    }

    @Override
    public List<ResourceLocation> getTexturesLocation() {
        ArrayList<ResourceLocation> arrayList = new ArrayList<ResourceLocation>(this.getMaxSize());
        for (int i = 1; i <= this.getMaxSize(); ++i) {
            arrayList.add(new ResourceLocation("blocks/" + this.getId() + "_stage_" + i));
        }
        return arrayList;
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    public int getMaxSize() {
        return this.maxAge;
    }

    @Override
    public boolean canGrow(ICropTile iCropTile) {
        return iCropTile.getCurrentSize() < this.getMaxSize() && iCropTile.getLightLevel() >= 9;
    }

    protected abstract ItemStack getSeeds();

    protected abstract ItemStack getProduct();

    @Override
    public ItemStack getGain(ICropTile iCropTile) {
        return this.getProduct();
    }

    @Override
    public ItemStack getSeeds(ICropTile iCropTile) {
        if (iCropTile.getStatGain() <= 1 && iCropTile.getStatGrowth() <= 1 && iCropTile.getStatResistance() <= 1) {
            return this.getSeeds();
        }
        return super.getSeeds(iCropTile);
    }
}

