/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IColoredEnergyTile;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.ILocatable;
import ic2.core.block.ChunkLoadAwareBlock;
import ic2.core.block.wiring.CableFoam;
import ic2.core.block.wiring.CableType;
import ic2.core.item.tool.ItemToolCutter;
import ic2.core.ref.Ic2Fluids;
import ic2.core.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CableBlock
extends Block
implements ChunkLoadAwareBlock,
SimpleWaterloggedBlock {
    public static final DyeColor DEFAULT_COLOR = DyeColor.BLACK;
    public static final CableFoam DEFAULT_FOAM = CableFoam.NONE;
    public static final EnumProperty<DyeColor> colorProperty = EnumProperty.m_61587_((String)"color", DyeColor.class);
    public static final EnumProperty<CableFoam> foamProperty = EnumProperty.m_61587_((String)"foam", CableFoam.class);
    public static final IntegerProperty connectionsProperty = IntegerProperty.m_61631_((String)"connections", (int)0, (int)63);
    private static final Map<CableType, Int2ReferenceMap<CableBlock>> types = new EnumMap<CableType, Int2ReferenceMap<CableBlock>>(CableType.class);
    private static final Int2ObjectMap<VoxelShape> shapes = new Int2ObjectOpenHashMap();
    private static boolean pendingHasColor;
    final CableType type;
    final int insulation;

    public static CableBlock create(BlockBehaviour.Properties properties, CableType cableType, int n) {
        CableBlock.prepareCreate(cableType, n);
        return new CableBlock(properties, cableType, n);
    }

    protected static void prepareCreate(CableType cableType, int n) {
        pendingHasColor = n >= cableType.minColoredInsulation;
    }

    protected CableBlock(BlockBehaviour.Properties properties, CableType cableType2, int n) {
        super(properties);
        if (n > cableType2.maxInsulation) {
            throw new IllegalArgumentException("invalid insulation " + n + " for type " + cableType2);
        }
        this.type = cableType2;
        this.insulation = n;
        BlockState blockState = (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(foamProperty, (Comparable)((Object)DEFAULT_FOAM))).m_61124_((Property)connectionsProperty, (Comparable)Integer.valueOf(0));
        if (n >= cableType2.minColoredInsulation) {
            blockState = (BlockState)blockState.m_61124_(colorProperty, (Comparable)DEFAULT_COLOR);
        }
        this.m_49959_(blockState);
        if (cableType2.maxInsulation > 0) {
            types.computeIfAbsent(cableType2, cableType -> new Int2ReferenceOpenHashMap(cableType.maxInsulation + 1)).put(n, (Object)this);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{foamProperty, connectionsProperty});
        if (pendingHasColor) {
            builder.m_61104_(new Property[]{colorProperty});
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (((CableFoam)((Object)blockState.m_61143_(foamProperty))).isPresent()) {
            return Shapes.m_83144_();
        }
        return CableBlock.getShape(this.type.getThickness(this.insulation), (Integer)blockState.m_61143_((Property)connectionsProperty));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VoxelShape getShape(float f, int n) {
        int n2 = Math.round(f * 256.0f) << 6 | n;
        Int2ObjectMap<VoxelShape> int2ObjectMap = shapes;
        synchronized (int2ObjectMap) {
            VoxelShape voxelShape = (VoxelShape)shapes.get(n2);
            if (voxelShape == null) {
                float f2 = (1.0f - f) / 2.0f;
                float f3 = f2 + f;
                voxelShape = Shapes.m_83048_((double)f2, (double)f2, (double)f2, (double)f3, (double)f3, (double)f3);
                for (Direction direction : Util.ALL_DIRS) {
                    float f4;
                    float f5;
                    boolean bl;
                    boolean bl2 = bl = (n & 1 << direction.ordinal()) != 0;
                    if (!bl) continue;
                    float f6 = f5 = f2;
                    float f7 = f5;
                    float f8 = f4 = f3;
                    float f9 = f4;
                    switch (direction) {
                        case DOWN: {
                            f6 = 0.0f;
                            f8 = f2;
                            break;
                        }
                        case UP: {
                            f6 = f3;
                            f8 = 1.0f;
                            break;
                        }
                        case NORTH: {
                            f5 = 0.0f;
                            f4 = f2;
                            break;
                        }
                        case SOUTH: {
                            f5 = f3;
                            f4 = 1.0f;
                            break;
                        }
                        case WEST: {
                            f7 = 0.0f;
                            f9 = f2;
                            break;
                        }
                        case EAST: {
                            f7 = f3;
                            f9 = 1.0f;
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)Shapes.m_83048_((double)f7, (double)f6, (double)f5, (double)f9, (double)f8, (double)f4));
                }
                shapes.put(n2, (Object)voxelShape);
            }
            return voxelShape;
        }
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        CableFoam cableFoam = (CableFoam)((Object)blockState.m_61143_(foamProperty));
        return !cableFoam.isPresent() && !cableFoam.isWaterlogged();
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockState blockState = this.m_49966_();
        Fluid fluid = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_()).m_76152_();
        if (fluid == Fluids.f_76193_) {
            blockState = (BlockState)blockState.m_61124_(foamProperty, (Comparable)((Object)CableFoam.WATERLOGGED));
        } else if (fluid == Ic2Fluids.CONSTRUCTION_FOAM.still) {
            blockState = (BlockState)blockState.m_61124_(foamProperty, (Comparable)((Object)CableFoam.SOFT));
        }
        return blockState;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((CableFoam)((Object)blockState.m_61143_(foamProperty))).isWaterlogged()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return blockState;
    }

    public FluidState m_5888_(BlockState blockState) {
        if (((CableFoam)((Object)blockState.m_61143_(foamProperty))).isWaterlogged()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return Fluids.f_76191_.m_76145_();
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        CableFoam cableFoam = (CableFoam)((Object)blockState.m_61143_(foamProperty));
        return !cableFoam.isPresent() && !cableFoam.isWaterlogged() && fluid == Fluids.f_76193_;
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (!this.m_6044_((BlockGetter)levelAccessor, blockPos, blockState, fluidState.m_76152_())) {
            return false;
        }
        if (!levelAccessor.m_5776_()) {
            levelAccessor.m_7731_(blockPos, (BlockState)blockState.m_61124_(foamProperty, (Comparable)((Object)CableFoam.WATERLOGGED)), 3);
            levelAccessor.m_186469_(blockPos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)levelAccessor));
        }
        return true;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        if (!((CableFoam)((Object)blockState.m_61143_(foamProperty))).isWaterlogged()) {
            return ItemStack.f_41583_;
        }
        levelAccessor.m_7731_(blockPos, (BlockState)blockState.m_61124_(foamProperty, (Comparable)((Object)CableFoam.NONE)), 3);
        return new ItemStack((ItemLike)Items.f_42447_);
    }

    public void m_6256_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        ItemStack itemStack = player.m_21211_();
        Item item = itemStack.m_41720_();
        if (item instanceof ItemToolCutter) {
            ((ItemToolCutter)item).removeInsulation(player, player.m_7655_(), blockState, level, blockPos);
        }
    }

    DyeColor getColor(BlockState blockState) {
        return CableBlock.getColor(blockState, this.type, this.insulation);
    }

    public static DyeColor getColor(BlockState blockState, CableType cableType, int n) {
        if (n >= cableType.minColoredInsulation) {
            return (DyeColor)blockState.m_61143_(colorProperty);
        }
        return DEFAULT_COLOR;
    }

    public boolean tryAddInsulation(BlockState blockState, Level level, BlockPos blockPos) {
        if (this.insulation >= this.type.maxInsulation) {
            return false;
        }
        if (((CableFoam)((Object)blockState.m_61143_(foamProperty))).isHard()) {
            return false;
        }
        CableBlock cableBlock = (CableBlock)types.get((Object)this.type).get(this.insulation + 1);
        if (cableBlock == null) {
            return false;
        }
        level.m_46597_(blockPos, CableBlock.copyState(blockState, cableBlock));
        return true;
    }

    public boolean tryRemoveInsulation(BlockState blockState, Level level, BlockPos blockPos, boolean bl) {
        if (this.insulation <= 0) {
            return false;
        }
        if (((CableFoam)((Object)blockState.m_61143_(foamProperty))).isHard()) {
            return false;
        }
        CableBlock cableBlock = (CableBlock)types.get((Object)this.type).get(this.insulation - 1);
        if (cableBlock == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        BlockState blockState2 = CableBlock.copyState(blockState, cableBlock);
        IEnergyTile iEnergyTile = null;
        if (this.insulation == this.type.minColoredInsulation && this.getColor(blockState) != DEFAULT_COLOR) {
            assert (cableBlock.getColor(blockState2) == DEFAULT_COLOR);
            if (!level.f_46443_ && (iEnergyTile = EnergyNet.instance.getTile(level, blockPos)) != null) {
                EnergyNet.instance.removeTile(iEnergyTile);
            }
        }
        level.m_46597_(blockPos, blockState2);
        if (iEnergyTile != null) {
            EnergyNet.instance.addTileUnchecked(iEnergyTile);
        }
        return true;
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState2.m_60713_((Block)this) || this.getColor(blockState2) != this.getColor(blockState)) {
            this.removeFromEnet(blockState, level, blockPos);
        }
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        this.addToEnet(blockState, level, blockPos, true);
    }

    @Override
    public void onLoad(BlockState blockState, Level level, BlockPos blockPos) {
        this.addToEnet(blockState, level, blockPos, false);
    }

    @Override
    public void onUnload(BlockState blockState, Level level, BlockPos blockPos) {
        this.removeFromEnet(blockState, level, blockPos);
    }

    protected void addToEnet(BlockState blockState, Level level, BlockPos blockPos, boolean bl) {
        if (bl && EnergyNet.instance.getTile(level, blockPos) != null) {
            return;
        }
        EnergyNet.instance.addLocatableTile(new Conductor(blockState, level, blockPos));
    }

    protected void removeFromEnet(BlockState blockState, Level level, BlockPos blockPos) {
        IEnergyTile iEnergyTile = EnergyNet.instance.getTile(level, blockPos);
        if (iEnergyTile != null) {
            EnergyNet.instance.removeTile(iEnergyTile);
        }
    }

    private static BlockState copyState(BlockState blockState, CableBlock cableBlock) {
        BlockState blockState2 = (BlockState)((BlockState)cableBlock.m_49966_().m_61124_(foamProperty, (Comparable)((Object)((CableFoam)((Object)blockState.m_61143_(foamProperty)))))).m_61124_((Property)connectionsProperty, (Comparable)((Integer)blockState.m_61143_((Property)connectionsProperty)));
        if (cableBlock.insulation >= cableBlock.type.minColoredInsulation) {
            blockState2 = (BlockState)blockState2.m_61124_(colorProperty, (Comparable)((CableBlock)blockState.m_60734_()).getColor(blockState));
        }
        return blockState2;
    }

    private final class Conductor
    implements ILocatable,
    IColoredEnergyTile,
    IEnergyConductor {
        private BlockState state;
        private final Level world;
        private final BlockPos pos;

        Conductor(BlockState blockState, Level level, BlockPos blockPos) {
            this.state = blockState;
            this.world = level;
            this.pos = blockPos.m_7949_();
        }

        @Override
        public Level getWorldObj() {
            return this.world;
        }

        @Override
        public BlockPos getPosition() {
            return this.pos;
        }

        @Override
        public DyeColor getColor(Direction direction) {
            return CableBlock.getColor(this.state, CableBlock.this.type, CableBlock.this.insulation);
        }

        @Override
        public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, Direction direction) {
            return this.canInteractWith(iEnergyEmitter, direction);
        }

        @Override
        public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, Direction direction) {
            return this.canInteractWith(iEnergyAcceptor, direction);
        }

        @Override
        public double getConductionLoss() {
            return CableBlock.this.type.loss;
        }

        @Override
        public double getInsulationEnergyAbsorption() {
            if (CableBlock.this.type.maxInsulation == 0) {
                return 2.147483647E9;
            }
            if (CableBlock.this.type.capacity < 128) {
                return EnergyNet.instance.getPowerFromTier(CableBlock.this.insulation);
            }
            return EnergyNet.instance.getPowerFromTier(CableBlock.this.insulation + 1);
        }

        @Override
        public double getInsulationBreakdownEnergy() {
            return 9001.0;
        }

        @Override
        public double getConductorBreakdownEnergy() {
            return CableBlock.this.type.capacity + 1;
        }

        @Override
        public void removeInsulation() {
            CableBlock.this.tryRemoveInsulation(this.state, this.world, this.pos, false);
        }

        @Override
        public void removeConductor() {
            this.world.m_7471_(this.pos, false);
        }

        @Override
        public void onConnectionChange() {
            int n = EnergyNet.instance.getAdjacentConnections(this);
            if (n != (Integer)this.state.m_61143_((Property)connectionsProperty)) {
                this.setState((BlockState)this.state.m_61124_((Property)connectionsProperty, (Comparable)Integer.valueOf(n)));
            }
        }

        private void setState(BlockState blockState) {
            assert (blockState != this.state);
            this.state = blockState;
            this.world.m_46597_(this.pos, blockState);
        }
    }
}

