/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.MachineRecipeResult;
import ic2.api.upgrade.UpgradableProperty;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.audio.SingleSound;
import ic2.core.block.invslot.InvSlotProcessableSmelting;
import ic2.core.block.machine.tileentity.TileEntityIronFurnace;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.ref.Ic2BlockEntities;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityElectricFurnace
extends TileEntityStandardMachine<ItemStack, ItemStack, ItemStack>
implements INetworkClientTileEntityEventListener {
    protected double xp = 0.0;
    protected SingleSound startingSound;
    protected SingleSound finishingSound;

    public TileEntityElectricFurnace(BlockPos blockPos, BlockState blockState) {
        super(Ic2BlockEntities.ELECTRIC_FURNACE, blockPos, blockState, 3, 100, 1);
        this.inputSlot = new InvSlotProcessableSmelting(this, "input", 1);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.xp = compoundTag.m_128459_("xp");
    }

    @Override
    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128347_("xp", this.xp);
    }

    @Override
    protected void onUnloaded() {
        super.onUnloaded();
        if (IC2.sideProxy.isRendering()) {
            if (this.startingSound != null) {
                if (!this.startingSound.isComplete()) {
                    this.startingSound.cancel();
                }
                this.startingSound = null;
            }
            if (this.finishingSound != null) {
                this.finishingSound.remove();
                this.finishingSound = null;
            }
        }
    }

    @Override
    protected Collection<ItemStack> getOutput(ItemStack itemStack) {
        return Collections.singletonList(itemStack);
    }

    @Override
    public void operateOnce(MachineRecipeResult<ItemStack, ItemStack, ItemStack> machineRecipeResult, Collection<ItemStack> collection) {
        super.operateOnce(machineRecipeResult, collection);
        this.xp += (double)machineRecipeResult.getRecipe().getMetaData().m_128457_("experience");
    }

    @Override
    public void onNetworkEvent(Player player, int n) {
        if (n == 0) {
            assert (!this.m_58904_().f_46443_);
            this.xp = TileEntityIronFurnace.spawnXP(player, this.xp);
        }
    }

    public String getStartingSoundFile() {
        return "Machines/Electro Furnace/ElectroFurnaceStart.ogg";
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/Electro Furnace/ElectroFurnaceLoop.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/Electro Furnace/ElectroFurnaceStop.ogg";
    }

    @Override
    public void onNetworkEvent(int n) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, this.getStartSoundFile(), true, false, IC2.audioManager.getDefaultVolume());
        }
        switch (n) {
            case 0: {
                if (this.startingSound != null) break;
                if (this.finishingSound != null) {
                    this.finishingSound.remove();
                    this.finishingSound = null;
                }
                this.startingSound = IC2.audioManager.playOnce(this, PositionSpec.Center, this.getStartingSoundFile(), false, IC2.audioManager.getDefaultVolume());
                if (this.audioSource == null) break;
                this.startingSound.onFinish(this.audioSource::play);
                break;
            }
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.startingSound != null) {
                    if (!this.startingSound.isComplete()) {
                        this.startingSound.cancel();
                    }
                    this.startingSound = null;
                }
                this.finishingSound = IC2.audioManager.playOnce(this, PositionSpec.Center, this.getInterruptSoundFile(), false, IC2.audioManager.getDefaultVolume());
            }
        }
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing);
    }
}

