/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.wiring.TileEntityElectricBlock;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.network.GrowingBuffer;
import ic2.core.network.GuiSynced;
import ic2.core.ref.Ic2BlockEntities;
import ic2.core.ref.Ic2Items;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityClassicElectrolyzer
extends TileEntityInventory
implements IHasGui {
    public TileEntityElectricBlock mfe = null;
    public int ticker = IC2.random.m_188503_(16);
    public final InvSlotConsumable waterSlot = new InvSlotConsumableId(this, "water", InvSlot.Access.IO, 1, InvSlot.InvSide.TOP, Ic2Items.WATER_CELL);
    public final InvSlotConsumable hydrogenSlot = new InvSlotConsumableId(this, "hydrogen", InvSlot.Access.IO, 1, InvSlot.InvSide.BOTTOM, Ic2Items.ELECTROLYZED_WATER_CELL);
    protected AudioSource audio;
    @GuiSynced
    protected final Energy energy = this.addComponent(new Energy(this, 20000.0, Util.noFacings, Util.noFacings, 1));

    public TileEntityClassicElectrolyzer(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType<? extends TileEntityInventory>)Ic2BlockEntities.CLASSIC_ELECTROLYZER, blockPos, blockState);
        this.comparator.setUpdate(this.energy::getComparatorValue);
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        if (this.m_58904_().f_46443_) {
            this.audio = IC2.audioManager.createSource(this, "Machines/ElectrolyzerLoop.ogg");
        }
    }

    @Override
    protected void onUnloaded() {
        super.onUnloaded();
        if (this.audio != null) {
            IC2.audioManager.removeSources(this);
            this.audio = null;
        }
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        boolean bl = false;
        boolean bl2 = false;
        if (++this.ticker % 16 == 0) {
            this.mfe = this.lookForMFE();
        }
        if (this.mfe == null) {
            return;
        }
        if (this.shouldDrain() && this.canDrain()) {
            bl |= this.drain();
            bl2 = true;
        }
        if (this.shouldPower() && (this.canPower() || this.energy.getEnergy() > 0.0)) {
            bl |= this.power();
            bl2 = true;
        }
        this.setActive(bl2);
        if (bl) {
            this.m_6596_();
        }
    }

    @Override
    protected void updateEntityClient() {
        super.updateEntityClient();
        if (this.ticker++ % 32 == 0 && this.audio != null) {
            this.audio.stop();
            if (this.getActive()) {
                this.audio.play();
            }
        }
    }

    public boolean shouldDrain() {
        return this.mfe != null && this.mfe.energy.getFillRatio() >= 0.7;
    }

    public boolean shouldPower() {
        return this.mfe != null && this.mfe.energy.getFillRatio() <= 0.3;
    }

    public boolean canDrain() {
        return this.waterSlot.consume(1, true, false) != null && (this.hydrogenSlot.isEmpty() || StackUtil.getSize(this.hydrogenSlot.get()) < Math.min(this.hydrogenSlot.getStackSizeLimit(), this.hydrogenSlot.get().m_41741_()));
    }

    public boolean canPower() {
        return this.hydrogenSlot.consume(1, true, false) != null && (this.waterSlot.isEmpty() || StackUtil.getSize(this.waterSlot.get()) < Math.min(this.waterSlot.getStackSizeLimit(), this.waterSlot.get().m_41741_()));
    }

    public boolean drain() {
        double d = this.processRate();
        if (!this.mfe.energy.useEnergy(d)) {
            return false;
        }
        this.energy.addEnergy(d);
        if (this.energy.useEnergy(20000.0)) {
            this.waterSlot.consume(1);
            if (this.hydrogenSlot.isEmpty()) {
                this.hydrogenSlot.put(new ItemStack((ItemLike)Ic2Items.ELECTROLYZED_WATER_CELL));
            } else {
                this.hydrogenSlot.put(StackUtil.incSize(this.hydrogenSlot.get()));
            }
            return true;
        }
        return false;
    }

    public boolean power() {
        if (this.energy.getEnergy() > 0.0) {
            double d = Math.min(this.energy.getEnergy(), (double)this.processRate());
            this.energy.useEnergy(d);
            this.mfe.energy.addEnergy(d);
            return false;
        }
        this.energy.forceAddEnergy(12000 + 2000 * this.mfe.energy.getSinkTier());
        this.hydrogenSlot.consume(1);
        if (this.waterSlot.isEmpty()) {
            this.waterSlot.put(new ItemStack((ItemLike)Ic2Items.WATER_CELL));
        } else {
            this.waterSlot.put(StackUtil.incSize(this.waterSlot.get()));
        }
        return true;
    }

    public int processRate() {
        switch (this.mfe.energy.getSinkTier()) {
            default: {
                return 2;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 32;
            }
            case 4: 
        }
        return 128;
    }

    public TileEntityElectricBlock lookForMFE() {
        Level level = this.m_58904_();
        for (Direction direction : Util.ALL_DIRS) {
            BlockEntity blockEntity = level.m_7702_(this.f_58858_.m_121945_(direction));
            if (!(blockEntity instanceof TileEntityElectricBlock)) continue;
            return (TileEntityElectricBlock)blockEntity;
        }
        return null;
    }

    @Override
    public ContainerBase<?> createServerScreenHandler(int n, Player player) {
        return DynamicContainer.create(n, player.m_150109_(), this);
    }

    @Override
    public ContainerBase<?> createClientScreenHandler(int n, Inventory inventory, GrowingBuffer growingBuffer) {
        return DynamicContainer.create(n, inventory, this);
    }
}

