/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.block.EntityIC2Explosive;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Redstone;
import ic2.core.util.StackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class Explosive
extends TileEntityInventory
implements Redstone.IRedstoneChangeHandler {
    protected final Redstone redstone = this.addComponent(new Redstone(this));
    private boolean exploded;

    protected Explosive(BlockEntityType<? extends Explosive> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType<? extends TileEntityInventory>)blockEntityType, blockPos, blockState);
        this.redstone.subscribe(this);
    }

    @Override
    public void onRedstoneChange(int n) {
        if (n > 0) {
            this.explode(null, false);
        }
    }

    @Override
    protected InteractionResult onActivated(Player player, InteractionHand interactionHand, Direction direction, Vec3 vec3) {
        if (StackUtil.consume(player, interactionHand, StackUtil.sameItem(Items.f_42613_), 1) || StackUtil.damage(player, interactionHand, StackUtil.sameItem(Items.f_42409_), 1)) {
            this.explode((LivingEntity)player, false);
            return InteractionResult.CONSUME;
        }
        return super.onActivated(player, interactionHand, direction, vec3);
    }

    @Override
    protected void onExploded(Explosion explosion) {
        super.onExploded(explosion);
        this.explode(explosion.m_46079_(), true);
    }

    @Override
    protected boolean onRemovedByPlayer(Player player, boolean bl) {
        if (this.explodeOnRemoval()) {
            this.explode((LivingEntity)player, false);
            return true;
        }
        return super.onRemovedByPlayer(player, bl);
    }

    @Override
    protected void onEntityCollision(Entity entity) {
        if (!this.m_58904_().f_46443_ && entity instanceof Projectile && entity.m_6060_()) {
            Projectile projectile = (Projectile)entity;
            Entity entity2 = projectile.m_37282_();
            this.explode(entity2 instanceof LivingEntity ? (LivingEntity)entity2 : null, false);
        }
    }

    @Override
    protected ItemStack adjustDrop(ItemStack itemStack, boolean bl) {
        if (this.exploded) {
            return null;
        }
        return super.adjustDrop(itemStack, bl);
    }

    protected boolean explode(LivingEntity livingEntity, boolean bl) {
        EntityIC2Explosive entityIC2Explosive = this.getEntity(livingEntity);
        if (entityIC2Explosive == null) {
            return false;
        }
        Level level = this.m_58904_();
        if (level.f_46443_) {
            return true;
        }
        entityIC2Explosive.setIgniter(livingEntity);
        this.onIgnite(livingEntity);
        level.m_7471_(this.f_58858_, false);
        if (bl) {
            entityIC2Explosive.fuse = level.f_46441_.m_188503_(Math.max(1, entityIC2Explosive.fuse / 4)) + entityIC2Explosive.fuse / 8;
        }
        level.m_7967_((Entity)entityIC2Explosive);
        level.m_6263_((Player)null, entityIC2Explosive.m_20185_(), entityIC2Explosive.m_20186_(), entityIC2Explosive.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.exploded = true;
        return true;
    }

    protected boolean explodeOnRemoval() {
        return false;
    }

    protected abstract EntityIC2Explosive getEntity(LivingEntity var1);

    protected void onIgnite(LivingEntity livingEntity) {
    }
}

