/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ic2.core.EnvProxy;
import ic2.core.IC2;
import ic2.core.block.RubberLogBlock;
import ic2.core.init.MainConfig;
import ic2.core.ref.Ic2Blocks;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class Ic2WorldGen {
    private static final WeightedStateProvider RUBBER_LOG_PROVIDER = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Ic2Blocks.RUBBER_LOG.m_49966_(), 16).m_146271_((Object)((BlockState)Ic2Blocks.RUBBER_LOG.m_49966_().m_61124_(RubberLogBlock.stateProperty, (Comparable)((Object)RubberLogBlock.RubberWoodState.wet_north))), 1).m_146271_((Object)((BlockState)Ic2Blocks.RUBBER_LOG.m_49966_().m_61124_(RubberLogBlock.stateProperty, (Comparable)((Object)RubberLogBlock.RubberWoodState.wet_east))), 1).m_146271_((Object)((BlockState)Ic2Blocks.RUBBER_LOG.m_49966_().m_61124_(RubberLogBlock.stateProperty, (Comparable)((Object)RubberLogBlock.RubberWoodState.wet_south))), 1).m_146271_((Object)((BlockState)Ic2Blocks.RUBBER_LOG.m_49966_().m_61124_(RubberLogBlock.stateProperty, (Comparable)((Object)RubberLogBlock.RubberWoodState.wet_west))), 1));
    public static final CompletableFuture<Holder<ConfiguredFeature<TreeConfiguration, ?>>> RUBBER_TREE = Ic2WorldGen.register("rubber_tree", Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)RUBBER_LOG_PROVIDER, (TrunkPlacer)new StraightTrunkPlacer(4, 4, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Ic2Blocks.RUBBER_LEAVES), (FoliagePlacer)RubberTreeFoliagePlacer.INSTANCE, (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_());
    public static final int chunkSize = 16;
    public static final int chunkOffset = 8;
    private static final int referenceMinY = -64;
    private static final int referenceHeight = 384;
    public static final int rubberTreeBiomeSamples = 4;
    public static final int rubberTreeSwampSpread = 10;
    public static final int rubberTreeSwampMin = 5;
    public static final int rubberTreeForestSpread = 5;
    public static final int rubberTreeForestMin = 1;
    public static final int rubberTreeDiv = 2;

    public static void init() {
        Config config = MainConfig.get().getSub("worldgen");
        boolean bl = ConfigUtil.getBool(config, "normalizeHeight");
        float f = Ic2WorldGen.getTreeScale(config);
        float f2 = Ic2WorldGen.getOreScale(config);
        if (Ic2WorldGen.rubberTreeGenEnabled(config) && f > 0.0f) {
            Ic2WorldGen.addRubberTreeFeature(f);
        }
        if (f2 > 0.0f) {
            int n = 256;
            Ic2WorldGen.addOreFeature("lead_ore", Ic2Blocks.LEAD_ORE.m_49966_(), config.getSub("lead"), bl, n, f2);
            Ic2WorldGen.addOreFeature("tin_ore", Ic2Blocks.TIN_ORE.m_49966_(), config.getSub("tin"), bl, n, f2);
            Ic2WorldGen.addOreFeature("uranium_ore", Ic2Blocks.URANIUM_ORE.m_49966_(), config.getSub("uranium"), bl, n, f2);
        }
        HeightModifier.init();
        NormalizedCountModifier.init();
        RubberTreeModifier.init();
        RubberTreeFoliagePlacer.init();
    }

    private static void addRubberTreeFeature(float f) {
        Ic2WorldGen.register("rubber_tree", RUBBER_TREE, EnvProxy.BiomeSelector.FOREST_JUNGLE_SWAMP, GenerationStep.Decoration.VEGETAL_DECORATION, new RubberTreeModifier(f));
    }

    private static void addOreFeature(String string, BlockState blockState, Config config, boolean bl, int n, float f) {
        int n2;
        if (!ConfigUtil.getBool(config, "enabled")) {
            return;
        }
        int n3 = ConfigUtil.getInt(config, "count");
        int n4 = ConfigUtil.getInt(config, "size");
        int n5 = ConfigUtil.getInt(config, "minHeight");
        if (n5 >= (n2 = ConfigUtil.getInt(config, "maxHeight"))) {
            return;
        }
        OreDistribution oreDistribution = OreDistribution.of(ConfigUtil.getString(config, "distribution"));
        CompletableFuture completableFuture = Ic2WorldGen.register(string, Feature.f_65731_, new OreConfiguration(OreFeatures.f_195072_, blockState, n4));
        Ic2WorldGen.register(string, completableFuture, EnvProxy.BiomeSelector.OVERWORLD, GenerationStep.Decoration.UNDERGROUND_ORES, new PlacementModifier[]{new NormalizedCountModifier((float)n3 * f, bl), InSquarePlacement.m_191715_(), VegetationPlacements.f_195420_, PlacementUtils.f_195355_, new HeightModifier(n5, n2, bl, oreDistribution)});
    }

    private static boolean rubberTreeGenEnabled(Config config) {
        return ConfigUtil.getBool(config, "rubberTree");
    }

    private static float getTreeScale(Config config) {
        return ConfigUtil.getFloat(config, "treeDensityFactor");
    }

    private static float getOreScale(Config config) {
        return ConfigUtil.getFloat(config, "oreDensityFactor");
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> CompletableFuture<Holder<ConfiguredFeature<FC, ?>>> register(String string, F f, FC FC) {
        return IC2.envProxy.registerConfiguredFeature(IC2.getIdentifier(string), f, FC);
    }

    private static <FC extends FeatureConfiguration> void register(String string, CompletableFuture<Holder<ConfiguredFeature<FC, ?>>> completableFuture, EnvProxy.BiomeSelector biomeSelector, GenerationStep.Decoration decoration, PlacementModifier ... placementModifierArray) {
        IC2.envProxy.registerPlacedFeature(IC2.getIdentifier(string), completableFuture, Arrays.asList(placementModifierArray), biomeSelector, decoration);
    }

    private static <T extends PlacementModifier> PlacementModifierType<T> registerPlacementModifier(String string, Codec<T> codec) {
        PlacementModifierType placementModifierType = () -> codec;
        IC2.envProxy.registerPlacementModifierType(IC2.getIdentifier(string), placementModifierType);
        return placementModifierType;
    }

    private static <T extends FoliagePlacer> FoliagePlacerType<T> registerFoliagePlacer(String string, Codec<T> codec) {
        return IC2.envProxy.registerFoliagePlacer(IC2.getIdentifier(string), codec);
    }

    private static final class HeightModifier
    extends PlacementModifier {
        static final Codec<HeightModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("minHeight").forGetter(heightModifier -> heightModifier.minHeight), (App)Codec.INT.fieldOf("maxHeight").forGetter(heightModifier -> heightModifier.maxHeight), (App)Codec.BOOL.fieldOf("normalize").forGetter(heightModifier -> heightModifier.normalize), (App)StringRepresentable.m_216439_(OreDistribution::values).fieldOf("distribution").forGetter(heightModifier -> heightModifier.distribution)).apply((Applicative)instance, HeightModifier::new));
        static final PlacementModifierType<HeightModifier> TYPE = Ic2WorldGen.registerPlacementModifier("ore_height", CODEC);
        private final int minHeight;
        private final int maxHeight;
        private final boolean normalize;
        private final OreDistribution distribution;

        static void init() {
        }

        private HeightModifier(int n, int n2, boolean bl, OreDistribution oreDistribution) {
            this.minHeight = n;
            this.maxHeight = n2;
            this.normalize = bl;
            this.distribution = oreDistribution;
        }

        public PlacementModifierType<?> m_183327_() {
            return TYPE;
        }

        public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
            int n = placementContext.m_142201_();
            int n2 = placementContext.m_142208_();
            int n3 = this.minHeight;
            int n4 = this.maxHeight;
            if (this.normalize) {
                n3 = n + (n3 - -64) * n2 / 384;
                n4 = n + (n4 - -64) * n2 / 384;
            }
            int n5 = n + n2;
            n3 = Util.limit(n3, n, n5);
            int n6 = (n4 = Util.limit(n4, n, n5)) - n3;
            if (n6 <= 0) {
                return Stream.empty();
            }
            if (n6 == 1) {
                return Stream.of(blockPos.m_175288_(n3));
            }
            return Stream.of(blockPos.m_175288_(switch (this.distribution) {
                case OreDistribution.UNIFORM -> randomSource.m_188503_(n6) + n3;
                case OreDistribution.TRIANGLE -> {
                    int var11_11 = n6 + 1 >>> 1;
                    yield randomSource.m_188503_(var11_11) + randomSource.m_188503_(n6 - var11_11) + n3;
                }
                case OreDistribution.RAMP -> n6 - 1 - (int)Math.sqrt(randomSource.m_188503_(n6 * n6)) + n3;
                case OreDistribution.REVRAMP -> (int)Math.sqrt(randomSource.m_188503_(n6 * n6)) + n3;
                case OreDistribution.SMOOTH -> {
                    int var11_12 = (n6 * 4 + 6) / 7;
                    int var12_13 = ((n6 - var11_12 + 1) * 2 + 2) / 3;
                    int var13_14 = n6 - var11_12 - var12_13 + 2;
                    yield randomSource.m_188503_(var11_12) + randomSource.m_188503_(var12_13) + randomSource.m_188503_(var13_14) + n3;
                }
                default -> throw new IllegalStateException();
            }));
        }
    }

    private static final class NormalizedCountModifier
    extends PlacementModifier {
        static final Codec<NormalizedCountModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("count").forGetter(normalizedCountModifier -> normalizedCountModifier.count), (App)Codec.BOOL.fieldOf("normalize").forGetter(normalizedCountModifier -> normalizedCountModifier.normalize)).apply((Applicative)instance, NormalizedCountModifier::new));
        static final PlacementModifierType<NormalizedCountModifier> TYPE = Ic2WorldGen.registerPlacementModifier("ore_count", CODEC);
        protected final double count;
        private final boolean normalize;

        static void init() {
        }

        NormalizedCountModifier(double d, boolean bl) {
            this.count = d;
            this.normalize = bl;
        }

        public PlacementModifierType<?> m_183327_() {
            return TYPE;
        }

        public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
            double d = this.count;
            if (d <= 0.0) {
                return Stream.empty();
            }
            d = randomSource.m_188583_() * Math.sqrt(d) + d;
            if (this.normalize) {
                d = d * (double)placementContext.m_142208_() / 384.0;
            }
            return IntStream.range(0, (int)Math.round(d)).mapToObj(n -> blockPos);
        }
    }

    private static class RubberTreeModifier
    extends PlacementModifier {
        static final Codec<RubberTreeModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("baseScale").forGetter(rubberTreeModifier -> rubberTreeModifier.baseScale)).apply((Applicative)instance, RubberTreeModifier::new));
        static final PlacementModifierType<RubberTreeModifier> TYPE = Ic2WorldGen.registerPlacementModifier("rubber_tree", CODEC);
        private final double baseScale;

        static void init() {
        }

        RubberTreeModifier(double d) {
            this.baseScale = d;
        }

        public PlacementModifierType<?> m_183327_() {
            return TYPE;
        }

        public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
            int n;
            int n2 = blockPos.m_123341_() >> 4;
            int n3 = blockPos.m_123343_() >> 4;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int n4 = 0;
            for (int i = 0; i < 4; ++i) {
                int n5 = n2 * 16 + (i & 1) * 15;
                n = n3 * 16 + ((i & 2) >>> 1) * 15;
                mutableBlockPos.m_122178_(n5, blockPos.m_123342_(), n);
                Holder holder = placementContext.m_191831_().m_204166_((BlockPos)mutableBlockPos);
                if (holder.m_203656_(BiomeTags.f_207589_)) {
                    n4 += randomSource.m_188503_(10) + 5;
                }
                if (!holder.m_203656_(BiomeTags.f_207611_) && !holder.m_203656_(BiomeTags.f_207610_)) continue;
                n4 += randomSource.m_188503_(5) + 1;
            }
            if ((n4 /= 2) <= 0 || randomSource.m_188503_(100) >= n4) {
                return Stream.empty();
            }
            BlockState blockState = Ic2Blocks.RUBBER_SAPLING.m_49966_();
            ArrayList<BlockPos> arrayList = new ArrayList<BlockPos>(1 + (n4 >>> 2));
            block1: for (n = 0; n < n4; ++n) {
                int n6;
                int n7 = n2 * 16 + randomSource.m_188503_(16);
                int n8 = placementContext.m_191824_(Heightmap.Types.OCEAN_FLOOR, n7, n6 = n3 * 16 + randomSource.m_188503_(16));
                if (n8 <= placementContext.m_191830_() || n8 < placementContext.m_191824_(Heightmap.Types.WORLD_SURFACE, n7, n6)) continue;
                mutableBlockPos.m_122178_(n7, n8, n6);
                if (!blockState.m_60710_((LevelReader)placementContext.m_191831_(), (BlockPos)mutableBlockPos)) continue;
                for (int i = 0; i < 4; ++i) {
                    mutableBlockPos.m_142448_(n8 + i);
                    if (!TreeFeature.m_67272_((LevelSimulatedReader)placementContext.m_191831_(), (BlockPos)mutableBlockPos)) continue block1;
                }
                mutableBlockPos.m_142448_(n8);
                arrayList.add(mutableBlockPos.m_7949_());
                n4 -= 3;
            }
            return arrayList.stream();
        }
    }

    private static final class RubberTreeFoliagePlacer
    extends FoliagePlacer {
        static final RubberTreeFoliagePlacer INSTANCE = new RubberTreeFoliagePlacer();
        static final Codec<RubberTreeFoliagePlacer> CODEC = Codec.unit((Object)((Object)INSTANCE));
        static final FoliagePlacerType<?> TYPE = Ic2WorldGen.registerFoliagePlacer("rubber_tree", CODEC);

        static void init() {
        }

        RubberTreeFoliagePlacer() {
            super((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0));
        }

        protected FoliagePlacerType<?> m_5897_() {
            return TYPE;
        }

        protected void m_213633_(LevelSimulatedReader levelSimulatedReader, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource randomSource, TreeConfiguration treeConfiguration, int n, FoliagePlacer.FoliageAttachment foliageAttachment, int n2, int n3, int n4) {
            int n5;
            int n6 = n < 4 ? 0 : (n < 7 ? 2 : 3);
            BlockPos blockPos = foliageAttachment.m_161451_();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (n5 = n6; n5 < n; ++n5) {
                for (int i = -n3; i <= n3; ++i) {
                    for (int j = -n3; j <= n3; ++j) {
                        mutableBlockPos.m_122154_((Vec3i)blockPos, i, n5 - n, j);
                        int n7 = n5 + 4 - n;
                        int n8 = Math.abs(i);
                        int n9 = Math.abs(j);
                        if ((n8 > 1 || n9 > 1) && (n8 > 1 || n7 > 1 && randomSource.m_188503_(n7) != 0) && (n9 > 1 || n7 > 1 && randomSource.m_188503_(n7) != 0)) continue;
                        FoliagePlacer.m_225622_((LevelSimulatedReader)levelSimulatedReader, biConsumer, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)mutableBlockPos);
                    }
                }
            }
            for (n5 = 0; n5 < n2; ++n5) {
                mutableBlockPos.m_122154_((Vec3i)blockPos, 0, n5, 0);
                FoliagePlacer.m_225622_((LevelSimulatedReader)levelSimulatedReader, biConsumer, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)mutableBlockPos);
            }
        }

        public int m_214116_(RandomSource randomSource, int n, TreeConfiguration treeConfiguration) {
            return 1 + n / 4 + randomSource.m_188503_(2);
        }

        protected boolean m_214203_(RandomSource randomSource, int n, int n2, int n3, int n4, boolean bl) {
            return false;
        }
    }

    private static enum OreDistribution implements StringRepresentable
    {
        UNIFORM("uniform"),
        TRIANGLE("triangle"),
        RAMP("ramp"),
        REVRAMP("revramp"),
        SMOOTH("smooth");

        private static final OreDistribution[] values;
        final String name;

        private OreDistribution(String string2) {
            this.name = string2;
        }

        public static OreDistribution of(String string) {
            for (OreDistribution oreDistribution : values) {
                if (!oreDistribution.name.equalsIgnoreCase(string)) continue;
                return oreDistribution;
            }
            throw new RuntimeException("Invalid/unknown worldgen distribution configured: " + string);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            values = OreDistribution.values();
        }
    }
}

