/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.tile.RetexturableBlock;
import ic2.api.tile.StainableBlock;
import ic2.core.block.TileEntityWall;
import ic2.core.ref.Ic2Blocks;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockWall
extends Block
implements StainableBlock,
RetexturableBlock {
    public static final DyeColor DEFAULT_COLOR = DyeColor.LIGHT_GRAY;
    private static final Map<DyeColor, BlockWall> types = new EnumMap<DyeColor, BlockWall>(DyeColor.class);
    final DyeColor color;

    public BlockWall(BlockBehaviour.Properties properties, DyeColor dyeColor) {
        super(properties);
        this.color = dyeColor;
        types.put(dyeColor, this);
    }

    @Override
    public DyeColor getColor(Level level, BlockPos blockPos, Direction direction) {
        return this.color;
    }

    @Override
    public boolean setColor(Level level, BlockPos blockPos, Direction direction, DyeColor dyeColor) {
        BlockWall blockWall;
        if (dyeColor != this.color && (blockWall = BlockWall.get(dyeColor)) != null) {
            level.m_46597_(blockPos, blockWall.m_49966_());
            return true;
        }
        return false;
    }

    @Override
    public boolean retexture(BlockState blockState, Level level, BlockPos blockPos, Direction direction, Player player, BlockState blockState2, String string, Direction direction2, int[] nArray) {
        level.m_46597_(blockPos, Ic2Blocks.OBSCURED_WALL.m_49966_());
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof TileEntityWall) {
            TileEntityWall tileEntityWall = (TileEntityWall)blockEntity;
            tileEntityWall.setColor(this.color);
            if (tileEntityWall.getBlockType().retexture(tileEntityWall.m_58900_(), level, blockPos, direction, player, blockState2, string, direction2, nArray)) {
                return true;
            }
        }
        level.m_46597_(blockPos, blockState);
        return false;
    }

    static BlockWall get(DyeColor dyeColor) {
        return types.get(dyeColor);
    }
}

