/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import com.google.common.base.Suppliers;
import ic2.api.tile.IWrenchable;
import ic2.api.tile.RetexturableBlock;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.Obscuration;
import ic2.core.util.Util;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BlockTileEntity
extends Block
implements EntityBlock,
IWrenchable,
RetexturableBlock {
    private static final BlockEntityTicker<TileEntityBlock> TICKER = new BlockEntityTicker<TileEntityBlock>(){

        public void tick(Level level, BlockPos blockPos, BlockState blockState, TileEntityBlock tileEntityBlock) {
            tileEntityBlock.tick();
        }
    };
    private static final LootContext.DynamicDrop DROPPER = new LootContext.DynamicDrop(){

        public void m_78987_(LootContext lootContext, Consumer<ItemStack> consumer) {
            BlockEntity blockEntity = (BlockEntity)lootContext.m_78953_(LootContextParams.f_81462_);
            if (blockEntity instanceof TileEntityBlock) {
                ItemStack itemStack = (ItemStack)lootContext.m_78953_(LootContextParams.f_81463_);
                int n = itemStack != null ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)itemStack) : 0;
                for (ItemStack itemStack2 : ((TileEntityBlock)blockEntity).getAuxDrops(n)) {
                    consumer.accept(itemStack2);
                }
            }
        }
    };
    private static final String facingPropertyName = "facing";
    private static final ResourceLocation AUX_DROPS = IC2.getIdentifier("aux");
    public static final Property<Direction> anyFacingProperty = DirectionProperty.m_61543_((String)"facing", Util.allFacings);
    public static final Property<Direction> horizontalFacingProperty = DirectionProperty.m_61543_((String)"facing", Util.horizontalFacings);
    public static final Property<Direction> verticalFacingProperty = DirectionProperty.m_61543_((String)"facing", Util.verticalFacings);
    private static final ThreadLocal<InitData> pendingInitData = new ThreadLocal();
    private final Class<? extends TileEntityBlock> teClass;
    private final boolean hasActive;
    private final DefaultDrop defaultDrop;
    private final boolean allowWrenchRotating;
    private final Set<Direction> supportedFacings;
    private final Supplier<TileEntityBlock> dummyTe;
    public final Property<Direction> facingProperty;

    public static BlockTileEntity create(BlockBehaviour.Properties properties, Class<? extends TileEntityBlock> clazz, boolean bl, DefaultDrop defaultDrop, Set<Direction> set, boolean bl2) {
        InitData initData = new InitData(set);
        pendingInitData.set(initData);
        BlockTileEntity blockTileEntity = new BlockTileEntity(properties, clazz, bl, initData, defaultDrop, bl2);
        pendingInitData.remove();
        return blockTileEntity;
    }

    private BlockTileEntity(BlockBehaviour.Properties properties, Class<? extends TileEntityBlock> clazz, boolean bl, InitData initData, DefaultDrop defaultDrop, boolean bl2) {
        super(properties);
        assert (initData == pendingInitData.get());
        this.teClass = clazz;
        this.hasActive = bl;
        this.defaultDrop = defaultDrop;
        this.allowWrenchRotating = bl2;
        this.supportedFacings = initData.supportedFacings;
        this.facingProperty = this.supportedFacings.size() > 1 ? this.f_49792_.m_61081_(facingPropertyName) : null;
        this.dummyTe = Suppliers.memoize(() -> this.createBlockEntity(BlockPos.f_121853_, this.m_49966_()));
    }

    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    public boolean hasActive() {
        return this.hasActive;
    }

    public DefaultDrop getDefaultDrop() {
        return this.defaultDrop;
    }

    public boolean allowWrenchRotating() {
        return this.allowWrenchRotating;
    }

    public Set<Direction> getSupportedFacings() {
        return this.supportedFacings;
    }

    public TileEntityBlock createBlockEntity(BlockPos blockPos, BlockState blockState) {
        try {
            return this.teClass.getConstructor(BlockPos.class, BlockState.class).newInstance(blockPos, blockState);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return TICKER;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        InitData initData = pendingInitData.get();
        Set<Direction> set = initData.supportedFacings;
        if (set.size() > 1) {
            if (set.equals(Util.allFacings)) {
                builder.m_61104_(new Property[]{anyFacingProperty});
            } else if (set.equals(Util.horizontalFacings)) {
                builder.m_61104_(new Property[]{horizontalFacingProperty});
            } else if (set.equals(Util.verticalFacings)) {
                builder.m_61104_(new Property[]{verticalFacingProperty});
            } else {
                builder.m_61104_(new Property[]{DirectionProperty.m_61543_((String)facingPropertyName, set)});
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockState blockState = super.m_5573_(blockPlaceContext);
        if (this.facingProperty != null) {
            blockState = (BlockState)blockState.m_61124_(this.facingProperty, (Comparable)this.getPlacementFacing((LivingEntity)blockPlaceContext.m_43723_(), blockPlaceContext.m_7820_()));
        }
        return blockState;
    }

    private Direction getPlacementFacing(LivingEntity livingEntity, Direction direction) {
        Set<Direction> set = this.getSupportedFacings();
        if (set.isEmpty()) {
            return Direction.DOWN;
        }
        if (livingEntity == null) {
            return direction != null && set.contains(direction.m_122424_()) ? direction.m_122424_() : this.getSupportedFacings().iterator().next();
        }
        Vec3 vec3 = livingEntity.m_20154_();
        Direction direction2 = null;
        double d = Double.NEGATIVE_INFINITY;
        for (Direction direction3 : set) {
            double d2 = vec3.m_82526_(Vec3.m_82528_((Vec3i)direction3.m_122424_().m_122436_()));
            if (!(d2 > d)) continue;
            d = d2;
            direction2 = direction3;
        }
        return direction2;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe((BlockGetter)level, blockPos);
        if (tileEntityBlock == null) {
            return;
        }
        tileEntityBlock.onPlaced(itemStack, livingEntity, this.facingProperty != null ? (Direction)blockState.m_61143_(this.facingProperty) : Direction.NORTH);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (!this.f_60443_) {
            return Shapes.m_83040_();
        }
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe(blockGetter, blockPos);
        if (tileEntityBlock == null) {
            return Shapes.m_83144_();
        }
        return tileEntityBlock.getOutlineShape(collisionContext);
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (!this.f_60443_) {
            return Shapes.m_83040_();
        }
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe(blockGetter, blockPos);
        if (tileEntityBlock == null) {
            return Shapes.m_83144_();
        }
        return tileEntityBlock.getCollisionShape(collisionContext);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe((BlockGetter)level, blockPos);
        if (tileEntityBlock == null) {
            return InteractionResult.PASS;
        }
        return tileEntityBlock.onActivated(player, interactionHand, blockHitResult.m_82434_(), blockHitResult.m_82450_());
    }

    public List<ItemStack> m_7381_(BlockState blockState, LootContext.Builder builder) {
        return super.m_7381_(blockState, builder.m_78979_(AUX_DROPS, DROPPER));
    }

    @Override
    public Direction getFacing(Level level, BlockPos blockPos) {
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe((BlockGetter)level, blockPos);
        if (tileEntityBlock == null) {
            return Direction.DOWN;
        }
        return tileEntityBlock.getFacing();
    }

    @Override
    public boolean canSetFacing(Level level, BlockPos blockPos, Direction direction, Player player) {
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe((BlockGetter)level, blockPos);
        if (tileEntityBlock == null) {
            return false;
        }
        return tileEntityBlock.canSetFacingWrench(direction, player);
    }

    @Override
    public boolean setFacing(Level level, BlockPos blockPos, Direction direction, Player player) {
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe((BlockGetter)level, blockPos);
        if (tileEntityBlock == null) {
            return false;
        }
        return tileEntityBlock.setFacingWrench(direction, player);
    }

    @Override
    public boolean wrenchCanRemove(Level level, BlockPos blockPos, Player player) {
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe((BlockGetter)level, blockPos);
        if (tileEntityBlock == null) {
            return false;
        }
        return tileEntityBlock.wrenchCanRemove(player);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity, Player player, int n) {
        return Block.m_49874_((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)blockPos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)player.m_21211_());
    }

    @Override
    public boolean retexture(BlockState blockState, Level level, BlockPos blockPos, Direction direction, Player player, BlockState blockState2, String string, Direction direction2, int[] nArray) {
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe((BlockGetter)level, blockPos);
        if (tileEntityBlock == null) {
            return false;
        }
        Obscuration obscuration = tileEntityBlock.getComponent(Obscuration.class);
        return obscuration == null ? false : obscuration.applyObscuration(direction, new Obscuration.ObscurationData(blockState2, string, direction2, nArray));
    }

    private static TileEntityBlock getTe(BlockGetter blockGetter, BlockPos blockPos) {
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        if (blockEntity instanceof TileEntityBlock) {
            return (TileEntityBlock)blockEntity;
        }
        return null;
    }

    public TileEntityBlock getDummyTe() {
        return this.dummyTe.get();
    }

    private static final class InitData {
        final Set<Direction> supportedFacings;

        InitData(Set<Direction> set) {
            this.supportedFacings = set;
        }
    }

    public static enum DefaultDrop {
        Self,
        None,
        Generator,
        Machine,
        AdvMachine;

    }
}

