/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.core.IC2;
import ic2.core.SideProxy;
import ic2.core.audio.AudioManager;
import ic2.core.util.Keyboard;
import ic2.core.util.Util;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public final class SideProxyServer
implements SideProxy {
    private static final AudioManager audioManager = new AudioManager();
    private static final Keyboard keyboard = new Keyboard();
    private static final Queue<Runnable> pendingTasks = new ArrayDeque<Runnable>();

    @Override
    public void preInit() {
    }

    @Override
    public void onPostInit() {
    }

    @Override
    public void playSoundSp(String string, float f, float f2) {
    }

    @Override
    public AudioManager getAudioManager() {
        return audioManager;
    }

    @Override
    public Keyboard getKeyboard() {
        return keyboard;
    }

    @Override
    public boolean isSimulating() {
        return true;
    }

    @Override
    public boolean isRendering() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestTick(boolean bl, Runnable runnable) {
        if (!bl) {
            throw new IllegalStateException();
        }
        MinecraftServer minecraftServer = IC2.envProxy.getServer();
        if (minecraftServer != null) {
            minecraftServer.execute(runnable);
        } else {
            Queue<Runnable> queue = pendingTasks;
            synchronized (queue) {
                minecraftServer = IC2.envProxy.getServer();
                if (minecraftServer != null) {
                    minecraftServer.execute(runnable);
                } else {
                    pendingTasks.add(runnable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServerAvailable(MinecraftServer minecraftServer) {
        Queue<Runnable> queue = pendingTasks;
        synchronized (queue) {
            Runnable runnable;
            while ((runnable = pendingTasks.poll()) != null) {
                minecraftServer.execute(runnable);
            }
        }
    }

    @Override
    public void displayError(String string, Object ... objectArray) {
        SideProxyServer.displayError0(string, objectArray);
    }

    static void displayError0(String object, Object ... objectArray) {
        if (objectArray.length > 0) {
            object = String.format((String)object, objectArray);
        }
        object = "IndustrialCraft 2 Error\n\n == = IndustrialCraft 2 Error = == \n\n" + (String)object + "\n\n == == == == == == == == == == ==\n";
        object = ((String)object).replace("\n", System.getProperty("line.separator"));
        throw new RuntimeException((String)object);
    }

    @Override
    public void displayError(Exception exception, String string, Object ... objectArray) {
        SideProxyServer.displayError(this, exception, string, objectArray);
    }

    static void displayError(SideProxy sideProxy, Exception exception, String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        sideProxy.displayError("An unexpected Exception occured.\n\n" + SideProxyServer.getStackTrace(exception) + "\n" + string, new Object[0]);
    }

    private static String getStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    @Override
    public Player getPlayerInstance() {
        return null;
    }

    @Override
    public Level getWorld(MinecraftServer minecraftServer, ResourceLocation resourceLocation) {
        for (Level level : minecraftServer.m_129785_()) {
            if (!resourceLocation.equals((Object)Util.getDimId(level))) continue;
            return level;
        }
        return null;
    }

    @Override
    public Level getPlayerWorld() {
        return null;
    }

    @Override
    public RecipeManager getRecipeManager() {
        return IC2.envProxy.getServer().m_129894_();
    }

    @Override
    public File getMinecraftDir() {
        return new File(".");
    }

    @Override
    public void messagePlayer(Player player, String string, Object ... objectArray) {
        if (player instanceof ServerPlayer) {
            MutableComponent mutableComponent = objectArray.length > 0 ? Component.m_237110_((String)string, (Object[])SideProxyServer.getMessageComponents(objectArray)) : Component.m_237115_((String)string);
            ((ServerPlayer)player).m_5661_((Component)mutableComponent, false);
        }
    }

    static Component[] getMessageComponents(Object ... objectArray) {
        Component[] componentArray = new Component[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            componentArray[i] = objectArray[i] instanceof String && ((String)objectArray[i]).startsWith("ic2.") ? Component.m_237115_((String)((String)objectArray[i])) : Component.m_237113_((String)objectArray[i].toString());
        }
        return componentArray;
    }

    @Override
    public <T extends BlockEntity> void registerRotorProvider(BlockEntityType<T> blockEntityType) {
    }
}

