/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.energy.EnergyNet;
import ic2.api.item.ElectricItem;
import ic2.api.recipe.Recipes;
import ic2.core.ChunkLoaderLogic;
import ic2.core.IC2;
import ic2.core.WorldData;
import ic2.core.apihelper.CoreAccessImpl;
import ic2.core.block.ChunkLoadAwareBlockHandler;
import ic2.core.block.Ic2WorldGen;
import ic2.core.block.comp.Components;
import ic2.core.block.generator.tileentity.TileEntitySemifluidGenerator;
import ic2.core.block.heatgenerator.tileentity.TileEntityFluidHeatGenerator;
import ic2.core.block.machine.tileentity.TileEntityBlockCutter;
import ic2.core.block.machine.tileentity.TileEntityElectrolyzer;
import ic2.core.block.machine.tileentity.TileEntityFermenter;
import ic2.core.block.machine.tileentity.TileEntityLiquidHeatExchanger;
import ic2.core.block.machine.tileentity.TileEntityMatter;
import ic2.core.block.machine.tileentity.TileEntityRecycler;
import ic2.core.crop.IC2Crops;
import ic2.core.energy.grid.EnergyNetGlobal;
import ic2.core.init.BlocksItems;
import ic2.core.init.MainConfig;
import ic2.core.init.Rezepte;
import ic2.core.item.ElectricItemManager;
import ic2.core.item.GatewayElectricItemManager;
import ic2.core.recipe.input.RecipeInputFactory;
import ic2.core.ref.Ic2BlockTags;
import ic2.core.ref.Ic2Entities;
import ic2.core.ref.Ic2ItemTags;
import ic2.core.ref.Ic2Items;
import ic2.core.ref.Ic2RecipeSerializers;
import ic2.core.ref.Ic2RecipeTypes;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public final class EventHandler {
    public static void onInitEarly() {
        long l = System.nanoTime();
        IC2.log.debug(LogCategory.General, "Starting pre-init.");
        MainConfig.load();
        CoreAccessImpl.init();
        IC2.sideProxy.getAudioManager().initialize();
        Recipes.inputFactory = new RecipeInputFactory();
        EnergyNet.instance = EnergyNetGlobal.create();
        ElectricItem.manager = new GatewayElectricItemManager();
        ElectricItem.rawManager = new ElectricItemManager();
        Components.init();
        BlocksItems.init();
        Ic2BlockTags.init();
        Ic2ItemTags.init();
        Ic2Entities.init();
        Ic2RecipeTypes.init();
        Ic2RecipeSerializers.init();
        Ic2WorldGen.init();
        TileEntityRecycler.init();
        TileEntityMatter.init();
        TileEntitySemifluidGenerator.init();
        TileEntityFluidHeatGenerator.init();
        TileEntityBlockCutter.init();
        TileEntityLiquidHeatExchanger.init();
        TileEntityFermenter.init();
        TileEntityElectrolyzer.init();
        Rezepte.registerRecipes();
        IC2Crops.init();
        IC2.sideProxy.preInit();
        IC2.initialized = true;
        IC2.log.debug(LogCategory.General, "Finished pre-init after %d ms.", (System.nanoTime() - l) / 1000000L);
    }

    public static void onInit() {
    }

    public static void onInitLate() {
        long l = System.nanoTime();
        IC2.sideProxy.onPostInit();
        IC2.sideProxy.requestTick(!IC2.envProxy.isClientEnv(), ChunkLoadAwareBlockHandler::init);
        IC2.log.debug(LogCategory.General, "Finished post-init after %d ms.", (System.nanoTime() - l) / 1000000L);
        IC2.log.info(LogCategory.General, "%s version %s loaded.", "ic2", "2.9.27+ex119");
    }

    private static boolean loadSubModule(String string) {
        IC2.log.debug(LogCategory.SubModule, "Loading %s submodule: %s.", "ic2", string);
        try {
            Class<?> clazz = IC2.class.getClassLoader().loadClass("ic2." + string + ".SubModule");
            return (Boolean)clazz.getMethod("init", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            IC2.log.debug(LogCategory.SubModule, "Submodule %s not loaded.", string);
            return false;
        }
    }

    public static void onServerStart(MinecraftServer minecraftServer) {
        IC2.sideProxy.onServerAvailable(minecraftServer);
    }

    public static void onPlayerLogout(Player player) {
        if (IC2.sideProxy.isSimulating()) {
            IC2.sideProxy.getKeyboard().removePlayerReferences(player);
        }
    }

    public static void onWorldLoad(Level level) {
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkLoaderLogic.onWorldLoad(serverLevel);
        }
    }

    public static void onWorldUnload(Level level) {
        WorldData.onWorldUnload(level);
    }

    public static void onChunkDataLoad(LevelChunk levelChunk, CompoundTag compoundTag) {
    }

    public static void onChunkSave(LevelChunk levelChunk, CompoundTag compoundTag) {
    }

    public static void onChunkLoad(LevelChunk levelChunk) {
        ChunkLoadAwareBlockHandler.onChunkLoad(levelChunk);
    }

    public static void onChunkUnload(LevelChunk levelChunk) {
        ChunkLoadAwareBlockHandler.onChunkUnload(levelChunk);
        if (!levelChunk.m_62953_().f_46443_) {
            ChunkLoaderLogic.onChunkUnload(levelChunk);
        }
    }

    public static void onPlayerTick(Player player) {
    }

    public static void onLivingSpecialSpawn(LivingEntity livingEntity) {
        if (IC2.seasonal && (livingEntity instanceof Zombie || livingEntity instanceof Skeleton) && livingEntity.m_20193_().f_46441_.m_188501_() < 0.1f) {
            Mob mob = (Mob)livingEntity;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                mob.m_21409_(equipmentSlot, Float.NEGATIVE_INFINITY);
            }
        }
    }

    public static boolean onLivingFall(LivingEntity livingEntity, float f) {
        if (livingEntity.m_20193_().f_46443_) {
            return false;
        }
        ItemStack itemStack = livingEntity.m_6844_(EquipmentSlot.FEET);
        if (StackUtil.isEmpty(itemStack)) {
            return false;
        }
        Item item = itemStack.m_41720_();
        return false;
    }

    public static boolean onEntityInteract(Player player, InteractionHand interactionHand, Entity entity) {
        if (player.m_20193_().f_46443_) {
            return false;
        }
        ItemStack itemStack = StackUtil.get(player, interactionHand);
        if (StackUtil.isEmpty(itemStack)) {
            return false;
        }
        Item item = itemStack.m_41720_();
        return false;
    }

    public static void onEntityFirstAttacked(LivingEntity livingEntity, DamageSource damageSource) {
    }

    public static int onGetBurnTime(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.m_41720_();
            if (item == Ic2Items.RUBBER_SAPLING) {
                return 80;
            }
            if (item == Items.f_41909_) {
                return 50;
            }
            if (item == Items.f_41982_) {
                return 50;
            }
            if (item == Ic2Items.SCRAP) {
                return 350;
            }
            if (item == Ic2Items.SCRAP_BOX) {
                return 3150;
            }
        }
        return -1;
    }
}

