/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.network.packet.server;

import cofh.lib.api.control.IRedstoneControllable;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.thermal.dynamics.ThermalDynamics;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.attachment.IRedstoneControllableAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AttachmentRedstoneControlPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected Direction side;
    protected int threshold;
    protected byte mode;

    public AttachmentRedstoneControlPacket() {
        super(34, ThermalDynamics.PACKET_HANDLER);
    }

    public void handleServer(ServerPlayer player) {
        IDuct duct;
        IAttachment iAttachment;
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IDuct && (iAttachment = (duct = (IDuct)tile).getAttachment(this.side)) instanceof IRedstoneControllableAttachment) {
            IRedstoneControllableAttachment attachment = (IRedstoneControllableAttachment)iAttachment;
            attachment.setControl(this.threshold, IRedstoneControllable.ControlMode.VALUES[this.mode]);
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.side);
        buf.writeInt(this.threshold);
        buf.writeByte((int)this.mode);
    }

    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.side = (Direction)buf.m_130066_(Direction.class);
        this.threshold = buf.readInt();
        this.mode = buf.readByte();
    }

    public static void sendToServer(IRedstoneControllableAttachment attachment) {
        AttachmentRedstoneControlPacket packet = new AttachmentRedstoneControlPacket();
        packet.pos = attachment.pos();
        packet.side = attachment.side();
        packet.threshold = attachment.redstoneControl().getThreshold();
        packet.mode = (byte)attachment.redstoneControl().getMode().ordinal();
        packet.sendToServer();
    }
}

